package com.app.yourradioapp593.utils;

import static com.solodroidx.ads.util.Constant.IRONSOURCE;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.app.yourradioapp593.BuildConfig;
import com.app.yourradioapp593.Config;
import com.app.yourradioapp593.R;
import com.app.yourradioapp593.database.prefs.AdsPref;
import com.app.yourradioapp593.database.prefs.SharedPref;
import com.solodroidx.ads.appopen.AppOpenAd;
import com.solodroidx.ads.banner.BannerAd;
import com.solodroidx.ads.gdpr.GDPR;
import com.solodroidx.ads.initialization.InitializeAd;
import com.solodroidx.ads.interstitial.InterstitialAd;
import com.solodroidx.ads.listener.OnShowAdCompleteListener;
import com.solodroidx.ads.nativead.NativeAd;
import com.solodroidx.ads.nativead.NativeAdView;
import com.solodroidx.ads.nativead.NativeAdViewHolder;

public class AdsManager {

    Activity activity;
    InitializeAd initializeAd;
    AppOpenAd appOpenAd;
    BannerAd bannerAd;
    InterstitialAd interstitialAd;
    NativeAd nativeAd;
    NativeAdView nativeAdView;
    SharedPref sharedPref;
    AdsPref adsPref;
    GDPR gdpr;

    public AdsManager(Activity activity) {
        this.activity = activity;
        this.sharedPref = new SharedPref(activity);
        this.adsPref = new AdsPref(activity);
        this.gdpr = new GDPR(activity);
        initializeAd = new InitializeAd(activity);
        appOpenAd = new AppOpenAd(activity);
        bannerAd = new BannerAd(activity);
        interstitialAd = new InterstitialAd(activity);
        nativeAd = new NativeAd(activity);
        nativeAdView = new NativeAdView(activity);
    }

    public void initializeAd() {
        if (adsPref.getAdStatus()) {
            initializeAd.setAdStatus("1")
                    .setAdNetwork(adsPref.getMainAds())
                    .setBackupAdNetwork(adsPref.getBackupAds())
                    .setAppLovinSdkKey(activity.getResources().getString(R.string.applovin_sdk_key))
                    .setStartappAppId(adsPref.getStartappAppId())
                    .setUnityGameId(adsPref.getUnityGameId())
                    .setIronSourceAppKey(adsPref.getIronSourceAppKey())
                    .setDebug(BuildConfig.DEBUG)
                    .build();
        }
    }

    public void loadAppOpenAd(boolean placement, boolean withListener, OnShowAdCompleteListener onShowAdCompleteListener) {
        if (placement) {
            if (adsPref.getAdStatus()) {
                appOpenAd.setAdStatus("1")
                        .setAdNetwork(adsPref.getMainAds())
                        .setBackupAdNetwork(adsPref.getBackupAds())
                        .setAdMobAppOpenId(adsPref.getAdMobAppOpenAdId())
                        .setAdManagerAppOpenId(adsPref.getAdManagerAppOpenAdId())
                        .setApplovinAppOpenId(adsPref.getAppLovinAppOpenAdUnitId())
                        .setWithListener(withListener)
                        .build(onShowAdCompleteListener);
            } else {
                onShowAdCompleteListener.onShowAdComplete();
            }
        }
    }

    public void showAppOpenAd(OnShowAdCompleteListener onShowAdCompleteListener) {
        appOpenAd.show(onShowAdCompleteListener);
    }

    public void destroyAppOpenAd() {
        appOpenAd.destroyOpenAd();
    }

    public void loadBannerAd(boolean placement) {
        if (placement) {
            if (adsPref.getAdStatus()) {
                bannerAd.setAdStatus("1")
                        .setAdNetwork(adsPref.getMainAds())
                        .setBackupAdNetwork(adsPref.getBackupAds())
                        .setAdMobBannerId(adsPref.getAdMobBannerId())
                        .setGoogleAdManagerBannerId(adsPref.getAdManagerBannerId())
                        .setFanBannerId(adsPref.getFanBannerId())
                        .setUnityBannerId(adsPref.getUnityBannerPlacementId())
                        .setAppLovinBannerId(adsPref.getAppLovinBannerAdUnitId())
                        .setAppLovinBannerZoneId(adsPref.getAppLovinBannerZoneId())
                        .setIronSourceBannerId(adsPref.getIronSourceBannerId())
                        .setIsCollapsibleBanner(false)
                        .setDarkTheme(sharedPref.getIsDarkTheme())
                        .build();
            }
        }
    }

    public void destroyBannerAd() {
        if (adsPref.getAdStatus()) {
            bannerAd.destroyAndDetachBanner();
        }
    }

    public void resumeBannerAd(boolean placement) {
        if (adsPref.getAdStatus() && !adsPref.getIronSourceBannerId().equals("0")) {
            if (adsPref.getMainAds().equals(IRONSOURCE) || adsPref.getBackupAds().equals(IRONSOURCE)) {
                loadBannerAd(placement);
            }
        }
    }

    public void loadInterstitialAd(boolean placement, int interval) {
        if (placement) {
            if (adsPref.getAdStatus()) {
                interstitialAd.setAdStatus("1")
                        .setAdNetwork(adsPref.getMainAds())
                        .setBackupAdNetwork(adsPref.getBackupAds())
                        .setAdMobInterstitialId(adsPref.getAdMobInterstitialId())
                        .setGoogleAdManagerInterstitialId(adsPref.getAdManagerInterstitialId())
                        .setFanInterstitialId(adsPref.getFanInterstitialId())
                        .setUnityInterstitialId(adsPref.getUnityInterstitialPlacementId())
                        .setAppLovinInterstitialId(adsPref.getAppLovinInterstitialAdUnitId())
                        .setAppLovinInterstitialZoneId(adsPref.getAppLovinInterstitialZoneId())
                        .setIronSourceInterstitialId(adsPref.getIronSourceInterstitialId())
                        .setInterval(interval)
                        .build();
            }
        }
    }

    public void showInterstitialAd() {
        if (adsPref.getAdStatus()) {
            interstitialAd.show();
        }
    }

    public void loadNativeAd(boolean placement, String style) {
        if (placement) {
            if (adsPref.getAdStatus()) {
                nativeAd.setAdStatus("1")
                        .setAdNetwork(adsPref.getMainAds())
                        .setBackupAdNetwork(adsPref.getBackupAds())
                        .setAdMobNativeId(adsPref.getAdMobNativeId())
                        .setAdManagerNativeId(adsPref.getAdManagerNativeId())
                        .setFanNativeId(adsPref.getFanNativeId())
                        .setAppLovinNativeId(adsPref.getAppLovinNativeAdManualUnitId())
                        .setAppLovinDiscoveryMrecZoneId(adsPref.getAppLovinBannerMrecZoneId())
                        .setNativeAdStyle(style)
                        .setRadius(R.dimen.corner_radius)
                        .setStrokeWidth(R.dimen.native_ad_stroke_width)
                        .setStrokeColor(R.color.color_stroke_native_ad)
                        .setBackgroundColor(R.color.color_light_native_ad_background, R.color.color_dark_native_ad_background)
                        .setMargin(R.dimen.no_margin, R.dimen.no_margin, R.dimen.no_margin, R.dimen.no_margin)
                        .setDarkTheme(sharedPref.getIsDarkTheme())
                        .build();
            }
        }
    }

    public void loadNativeAdView(View view, String nativeAdStyle, boolean placement) {
        if (placement) {
            if (adsPref.getAdStatus()) {
                nativeAdView.setView(view)
                        .setAdStatus("1")
                        .setAdNetwork(adsPref.getMainAds())
                        .setBackupAdNetwork(adsPref.getBackupAds())
                        .setAdMobNativeId(adsPref.getAdMobNativeId())
                        .setAdManagerNativeId(adsPref.getAdManagerNativeId())
                        .setFanNativeId(adsPref.getFanNativeId())
                        .setAppLovinNativeId(adsPref.getAppLovinNativeAdManualUnitId())
                        .setAppLovinDiscoveryMrecZoneId(adsPref.getAppLovinBannerMrecZoneId())
                        .setNativeAdStyle(nativeAdStyle)
                        .setRadius(R.dimen.corner_radius)
                        .setStrokeWidth(R.dimen.native_ad_stroke_width)
                        .setStrokeColor(R.color.color_stroke_native_ad)
                        .setBackgroundColor(R.color.color_light_native_ad_background, R.color.color_dark_native_ad_background)
                        .setMargin(R.dimen.no_margin, R.dimen.margin_medium, R.dimen.no_margin, R.dimen.margin_medium)
                        .setDarkTheme(sharedPref.getIsDarkTheme())
                        .build();
            }
        }
    }

    public RecyclerView.ViewHolder createNativeAdViewHolder(Context context, @NonNull ViewGroup parent) {
        String adStatus;
        if (adsPref.getAdStatus()) {
            adStatus = "1";
        } else {
            adStatus = "0";
        }

        int noMargin = R.dimen.no_margin;
        int marginEnd = R.dimen.margin_medium;

        return new NativeAdViewHolder(NativeAdViewHolder.setLayoutInflater(parent, Tools.nativeAdStyleFormatter(Config.NATIVE_AD_STYLE_RADIO_LIST)))
                .setAdStatus(adStatus)
                .setAdNetwork(adsPref.getMainAds())
                .setBackupAdNetwork(adsPref.getBackupAds())
                .setAdMobNativeId(adsPref.getAdMobNativeId())
                .setAdManagerNativeId(adsPref.getAdManagerNativeId())
                .setFanNativeId(adsPref.getFanNativeId())
                .setAppLovinNativeId(adsPref.getAppLovinNativeAdManualUnitId())
                .setAppLovinDiscoveryMrecZoneId(adsPref.getAppLovinBannerMrecZoneId())
                .setNativeAdStyle(Tools.nativeAdStyleFormatter(Config.NATIVE_AD_STYLE_RADIO_LIST))
                .setBackgroundColor(R.color.color_light_native_ad_background, R.color.color_dark_native_ad_background)
                .setRadius(context, R.dimen.corner_radius)
                .setStrokeWidth(context, R.dimen.native_ad_stroke_width)
                .setStrokeColor(context, R.color.color_stroke_native_ad)
                .setMargin(context, noMargin, noMargin, noMargin, marginEnd)
                //.setPadding(context, noPadding, padding, noPadding, padding)
                .setDarkTheme(sharedPref.getIsDarkTheme());
    }

    public void bindNativeAdViewHolder(Context context, NativeAdViewHolder holder) {
        holder.buildNativeAd(context);
    }

    public void updateConsentStatus() {
        if (Config.ENABLE_GDPR_EU_CONSENT_UMP_SDK) {
            gdpr.updateGDPRConsentStatus(adsPref.getMainAds(), false, false);
        }
    }

}
